/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils.kryo;

import com.xforceplus.janus.message.common.utils.kryo.KryoUtils;
import com.xforceplus.janus.message.common.utils.kryo.io.KryoObjectInput;
import com.xforceplus.janus.message.common.utils.kryo.io.KryoObjectOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class KryoRedisSerializer<T>
implements RedisSerializer<T> {
    public byte[] serialize(Object object) throws SerializationException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        KryoObjectOutput out = new KryoObjectOutput(KryoUtils.get(), bos);
        out.writeClassAndObject(object);
        out.flush();
        return bos.toByteArray();
    }

    public T deserialize(byte[] data) throws SerializationException {
        KryoObjectInput input = new KryoObjectInput(KryoUtils.get(), new ByteArrayInputStream(data));
        return input.readClassAndObject();
    }
}

