package com.xforceplus.janus.message.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 响应消息
 *
 * @author zhujie@xforceplus.com
 * @date 2021/3/3 2:53 PM
 **/
@ApiModel("响应消息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ResponseMessage extends RequestMessage implements Serializable {
    @ApiModelProperty(value = "消息ID，总线服务生成")
    private Long id;

    @ApiModelProperty(value = "发布代码")
    private String pubCode;

    @ApiModelProperty(value = "发布者appKey")
    private String pubAppKey;

    @ApiModelProperty(value = "第三方消息ID", example = "RocketMQ,SQS")
    private String thirdPartyId;

    @ApiModelProperty(value = "接收时间戳，用来记录消息总线服务接收到消息的时间点")
    private long receivedTime;

    @ApiModelProperty(value = "消费次数，消息被订阅者或者消费者消费次数")
    private Integer consumeTimes;

    @ApiModelProperty(value = "回执标记")
    private String receiptHandle;

    @ApiModelProperty(value = "businessNo")
    private String uniqueId;

    @ApiModelProperty(value = "消息来源ID,pubsub、sqs、自己的")
    private String sourceMessageId;

    @ApiModelProperty(value = "是否回放消息 0否 1是")
    private Integer isPlayMessage;

}
