package com.xforceplus.janus.message.common.dto.admin;

import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections4.MapUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 请求消息
 *
 * @author zhujie@xforceplus.com
 * @date 2021/3/3 2:53 PM
 **/
@ApiModel("修改消息后重放请求体")
@Data
public class ModifyMessageReplayRequestDTO implements Serializable {

    private static final long serialVersionUID = -1217036119248730334L;
    @ApiModelProperty(value = "pubAppKey")
    @NotBlank(message="pubAppKey不能为空")
    private String pubAppKey;

    @ApiModelProperty(value = "pubCode")
    @NotBlank(message="pubCode不能为空")
    private String pubCode;

    @ApiModelProperty(value = "messageId")
    @NotNull(message="messageId不能为空")
    private Long messageId;


    @ApiModelProperty(value = "subAppKey")
    private String subAppKey;

    @NotNull(message="创建时间不能为空")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdTime;

    @ApiModelProperty(value = "唯一ID，用于幂等处理", required = false)
    private String uniqueId;


    @ApiModelProperty(value = "消息内容", required = true, notes = "格式为字符串")
    @NotEmpty(message="消息内容不能为空")
    private String content;

    @ApiModelProperty(value = "消息属性Map", required = false)
    private Map<String, String> properties;

    public Map<String, String> getProperties() {
        if (MapUtils.isEmpty(properties)) {
            properties = new HashMap<>();
        }
        return properties;
    }
}
