package com.xforceplus.janus.message.common.enums;

public enum AliyunSmsTemplateStatusEnum {

    APPROVING(10, "审核中"),

    APPROVED(11, "审核通过"),

    REJECTED(12, "审核未通过");

    private Integer code;

    private String desc;

    AliyunSmsTemplateStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static AliyunSmsTemplateStatusEnum getByCode(Integer code) {
        for (AliyunSmsTemplateStatusEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("模板状态没找到");
    }
}
