/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.config;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebConfigurer
implements ServletContextInitializer,
WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
    private static final Logger log = LoggerFactory.getLogger(WebConfigurer.class);

    public void onStartup(ServletContext servletContext) {
    }

    public void customize(UndertowServletWebServerFactory factory) {
        this.setWebSocketDeploymentInfo(factory);
    }

    private void setWebSocketDeploymentInfo(UndertowServletWebServerFactory factory) {
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> {
            WebSocketDeploymentInfo webSocketDeploymentInfo = new WebSocketDeploymentInfo();
            webSocketDeploymentInfo.setBuffers((ByteBufferPool)new DefaultByteBufferPool(false, 1024));
            deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)webSocketDeploymentInfo);
        }});
    }
}

