/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils.kryo.factory;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.xforceplus.janus.message.common.utils.reflection.ReflectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibleKryo
extends Kryo {
    private static final Logger log = LoggerFactory.getLogger(CompatibleKryo.class);

    public Serializer<?> getDefaultSerializer(Class type) {
        Validate.isTrue((type != null ? 1 : 0) != 0, (String)"Type must NOT be null!", (Object[])new Object[0]);
        if (!(ReflectionUtils.isJdkClass(type) || type.isArray() || type.isEnum() || ReflectionUtils.hasZeroArgConstructor(type))) {
            if (log.isWarnEnabled()) {
                log.warn(type + " has NO zero-argument constructor therefore it will reduce serialization performance. " + "You can register the custom Serializer for the type to remove the alert.");
            }
            return new JavaSerializer();
        }
        return super.getDefaultSerializer(type);
    }
}

