package com.xforceplus.janus.message.common.enums;//package com.xforceplus.janus.message.common.enums;

public enum EnvEnum {

    DEV("DEV", "开发"),

    SIT("SIT", "系统集成测试，开发人员自己测试流程是否走通"),

    FAT("FAT", "功能验收测试环境，用于软件测试者测试使用"),

    TEST("TEST", "测试环境，外部用户无法访问，专门给测试人员使用的，版本相对稳定"),

    UAT("UAT", "用户验收测试环境，用于生产环境下的软件测试者测试使用"),

    DEMO("DEMO", "演示"),

    PROD("PROD", "生产");

    private String code;

    private String desc;

    EnvEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static EnvEnum getByCode(String code) {
        for (EnvEnum i : values()) {
            if (i.getCode().equals(code.toUpperCase())) {
                return i;
            }
        }
        return null;
    }

    public static EnvEnum getByCodeException(String code) {
        EnvEnum envEnum = getByCode(code);
        if (envEnum == null) {
            throw new IllegalArgumentException("环境没有匹配到");
        }
        return envEnum;
    }
}
