package com.xforceplus.janus.message.common.utils;

import com.jayway.jsonpath.JsonPath;
import com.xforceplus.janus.message.common.dto.api.TemplateParamMappingRuleDTO;
import com.xforceplus.janus.shooter.core.entity.TagRuleTag;
import com.xforceplus.janus.shooter.core.enums.TagTypeEnum;
import com.xforceplus.janus.shooter.core.gun.Gun;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.xforceplus.janus.shooter.core.Shooter.GUN_MAP;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/21 3:28 PM
 **/
public class MappingUtil {

    public static Map<String, String> transform(String message, List<TemplateParamMappingRuleDTO> templateParamMappingRuleDTOS) {
        Map<String, String> templateParam = new HashMap<>();

        if (CollectionUtils.isEmpty(templateParamMappingRuleDTOS)) {
            return templateParam;
        }
        Gun gun = GUN_MAP.get(TagTypeEnum.ATTR.getCode());

        templateParamMappingRuleDTOS.forEach(
                dto -> {
                    String paramType = dto.getParamType();
                    String paramVal = dto.getParamVal();
                    if (paramType.equalsIgnoreCase(TemplateParamMappingRuleDTO.PARAM_TYPE_JSONPATH)) {
                        TagRuleTag tag = new TagRuleTag();
                        tag.setTagName(dto.getParamVal());
                        tag.setTagKey("mapping");
                        tag.setTagType(TagTypeEnum.ATTR.getCode());
                        Map<String, String> tags = gun.shoot(JsonPath.parse(message), tag);


                        if (MapUtils.isNotEmpty(tags)) {
                            List<String> result = tags.values().stream()
                                    .collect(Collectors.toList());

                            paramVal = result.get(0);
                        }
                    }

                    templateParam.put(dto.getParamVal(), paramVal);
                }
        );
        return templateParam;
    }
}
