package com.xforceplus.janus.message.common.dto.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author tianyang
 * @date 2021/09/02 15:06
 **/
@Data
public class MessageOverstockSubDTO {
    private String                          subAppKey;
    private Integer                         pushQuantity;
    private Integer                         pullQuantity;
    private Integer                         overstockQuantity;
    private Integer                         ackQuantity;
    private Double                          ackRatio;
    private Double                          overstockRatio;
    private String                          subAppRemark;
    private List<MessageOverstockSubPubDTO> subPubDTOs;
    // 消息积压量上限告警
    public  boolean                         overStockQuantityLimitAlarm;
    // 消息积压率上限告警
    public  boolean                         overStockRatioLimitAlarm;
    // 消息回执率下限告警
    public  boolean                         ackRatioLimitAlarm;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date                            startTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date                            endTime;
}
