package com.xforceplus.janus.message.common.enums;

public enum SubNotifyTypeEnum {

    PULL(0, "主动拉取"),

    CALLBACK(1, "主动回调"),

    ;

    private Integer code;

    private String desc;

    SubNotifyTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static SubNotifyTypeEnum getByCode(int code) {
        for (SubNotifyTypeEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("订阅通知类型没找到");
    }
}
