package com.xforceplus.janus.message.common.dto.admin;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/4/22 10:58 AM
 **/
@Data
public class QueryMessageDTO {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "messageId")
    @NotBlank(message="messageId不能为空")
    private String messageId;

    @NotNull(message="创建时间不能为空")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdTime;

}
