package com.xforceplus.janus.message.common.dto.admin;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/4/22 10:58 AM
 **/
@Data
public class SingleMessageReplayTaskAddDTO implements Serializable {


    private static final long serialVersionUID = -6254916844879724402L;
    @ApiModelProperty(value = "pubAppKey")
    @NotBlank(message = "pubAppKey不能为空")
    private String pubAppKey;

    @ApiModelProperty(value = "pubCode")
    @NotBlank(message = "pubCode不能为空")
    private String pubCode;

    @ApiModelProperty(value = "messageId")
    @NotBlank(message = "messageId不能为空")
    private String messageId;


    @ApiModelProperty(value = "subAppKey")
    private String subAppKey;

    @NotNull(message = "创建时间不能为空")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdTime;


}
