package com.xforceplus.janus.message.common.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class DateTimeUtils {

    private static final String DATE_FORMAT     = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String MINUTE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String SPILT_CHAR = "@@";

    public static List<String> getDays(String startTime, String endTime, String format) {
        // 返回的日期集合
        List<String> days = new ArrayList<String>();

        DateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);

            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);

            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(Calendar.DATE, +1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(Calendar.DAY_OF_YEAR, 1);
            }

        } catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static List<String> getDays(Date start, Date end, String format) {
        // 返回的日期集合
        List<String> days = new ArrayList<String>();

        DateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(Calendar.DATE, +1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(Calendar.DAY_OF_YEAR, 1);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return days;
    }
    // ---------------------- add date ----------------------

    public static Date addYears(final Date date, final int amount) {
        return add(date, Calendar.YEAR, amount);
    }

    public static Date addMonths(final Date date, final int amount) {
        return add(date, Calendar.MONTH, amount);
    }

    public static Date addDays(final Date date, final int amount) {
        return add(date, Calendar.DAY_OF_MONTH, amount);
    }

    public static Date addSeconds(final Date date, final int amount) {
        return add(date, Calendar.SECOND, amount);
    }

    public static Date addMinutes(final Date date, final int amount) {
        return add(date, Calendar.MINUTE, amount);
    }

    public static Date addHours(final Date date, final int amount) {
        return add(date, Calendar.HOUR_OF_DAY, amount);
    }

    private static Date add(final Date date, final int calendarField, final int amount) {
        if (date == null) {
            return null;
        }
        final Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    private static final ThreadLocal<Map<String, DateFormat>> dateFormatThreadLocal = new ThreadLocal<Map<String, DateFormat>>();

    private static DateFormat getDateFormat(String pattern) {
        if (pattern == null || pattern.trim().length() == 0) {
            throw new IllegalArgumentException("pattern cannot be empty.");
        }

        Map<String, DateFormat> dateFormatMap = dateFormatThreadLocal.get();
        if (dateFormatMap != null && dateFormatMap.containsKey(pattern)) {
            return dateFormatMap.get(pattern);
        }

        synchronized (dateFormatThreadLocal) {
            if (dateFormatMap == null) {
                dateFormatMap = new HashMap<String, DateFormat>();
            }
            dateFormatMap.put(pattern, new SimpleDateFormat(pattern));
            dateFormatThreadLocal.set(dateFormatMap);
        }

        return dateFormatMap.get(pattern);
    }

    public static String format(Date date, String patten) {
        return getDateFormat(patten).format(date);
    }

    public static Date parse(String dateStr, String patten) {
        try {
            return getDateFormat(patten).parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date parseDateTime(String dateStr) {
        return parse(dateStr, DATETIME_FORMAT);
    }

    public static String formatDate(Date date) {
        return format(date, DATE_FORMAT);
    }

    public static String formatDateTime(Date date) {
        return format(date, DATETIME_FORMAT);
    }
    public static String formatMinute(Date date) {
        return format(date, MINUTE_FORMAT);
    }

    //当天的零时零分零秒
    public static Date getZeroTimeOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date newDate = calendar.getTime();
        return newDate;
    }

    //当天的23时59分59秒
    public static Date getLastTimeOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        Date newDate = calendar.getTime();
        return newDate;
    }

    //当月第一天的零时零分零秒
    public static Date getFirstDateOfCurrentMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date newDate = calendar.getTime();
        return newDate;
    }

    //当年第一天的零时零分零秒
    public static Date getFirstDateOfCurrentYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.MONTH, 0);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date newDate = calendar.getTime();
        return newDate;
    }

    //零秒
    public static Date getZeroSecondOfCurrentMinute(String dateStr) throws ParseException {
        Date date = getDateFormat(DATETIME_FORMAT).parse(dateStr);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.SECOND, 0);
        Date newDate = calendar.getTime();
        return newDate;
    }

    //零秒
    public static Date getZeroSecondOfCurrentMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.SECOND, 0);
        Date newDate = calendar.getTime();
        return newDate;
    }


//    public static void main(String[] args) throws ParseException {
////        List<String> list= getDays("2021-06-01 15:30:23" ,"2021-06-18 15:30:33" ,"yyyy-MM-dd HH:mm:ss" );
////        List<String> list= getDays("2021-06-01 15:30:23" ,"2021-06-18 15:30:33" ,"yyyy-MM-dd" );
////        System.out.println(list);
////        Date now = new Date();
////        System.out.println(formatDateTime(getFirstDateOfCurrentMonth(now)));
////        System.out.println(formatDateTime(getFirstDateOfCurrentYear(now)));
////        System.out.println(formatDateTime(now));
////        System.out.println(formatDateTime(addHours(now,-23)));
//        String dateStr = "2021-09-01 14:20:00";
//        Date newDate = getZeroSecondOfCurrentMinute(dateStr);
//        Map<String,String> sub_map= new HashMap<String,String>();
//        sub_map.put(dateStr,getKey(dateStr,dateStr));
//        System.out.println(getDateFormat(DATETIME_FORMAT).format(newDate));
//        System.out.println(sub_map.get(dateStr));
//
//    }

    public static String getKey(String... args) {
        return String.join(SPILT_CHAR, args).toUpperCase();
    }
}
