package com.xforceplus.janus.message.common.dto.admin;

import com.xforceplus.janus.message.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Positive;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "定时任务对象")
public class ScheduledTaskDTO extends BaseEntity implements Serializable {
    private static final long         serialVersionUID              = 8878535528271740314L;
    public static final  String       UNIT_MINUTES                  = "MINUTES";
    public static final  String       UNIT_HOURS                    = "HOURS";
    public static final  String       UNIT_DAYS                     = "DAYS";
    public static final  List<String> AVAILABLE_FIXED_INTERVAL_UNIT = Arrays.asList(UNIT_MINUTES, UNIT_HOURS, UNIT_DAYS);
    /**
     * Task name(唯一键)
     */
    @ApiModelProperty(value = "任务名称")
    private              String       name;
    /**
     * Spring bean name
     */
    @NotEmpty
    @ApiModelProperty(value = "spring bean名称")
    private              String       beanName;
    /**
     * Method arguments JSON string
     */
    @ApiModelProperty(value = "方法参数JSON字符串")
    private              String       argumentsJson;
    /**
     * Indicates whether it use cron expression, or fixed interval
     */
    @ApiModelProperty(value = "是否使用CRON表达式")
    private              Boolean      useCronExpression;
    /**
     * Cron expression
     */
    @ApiModelProperty(value = "CRON表达式")
    private              String       cronExpression;
    /**
     * Fixed rate interval
     */
    @Positive
    @ApiModelProperty(value = "固定间隔时长")
    private              Long         fixedInterval;
    /**
     * Time unit of fixed rate interval, e.g. MINUTES, HOURS, DAYS
     */
    @ApiModelProperty(value = "固定间隔时间单位")
    private              String       fixedIntervalUnit;
    /**
     * Start time
     */
    @ApiModelProperty(value = "开始时间")
    private              Instant      startTime;
    /**
     * Stop time
     */
    @ApiModelProperty(value = "结束时间")
    private              Instant      stopTime;
    /**
     * Remarks
     */
    @ApiModelProperty(value = "备注")
    private              String       remark;
}