package com.xforceplus.janus.message.common.dto.admin;

import com.xforceplus.janus.message.entity.BaseEntity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/26 2:13 PM
 **/
@Data
public class FilterRuleDetailDto extends BaseEntity {


    @ApiModelProperty(value = "过滤规则ID")
    private String filterRuleId;

    @ApiModelProperty(value = "过滤内容类型 0：属性 1：内容")
    private Integer filterContentType;

    @ApiModelProperty(value = "0 代表是1级  当非0的时候，这pid 对应的 过滤条件只有sort_num其他字段不需要看")
    private String pid;

    @ApiModelProperty(value = "逻辑运算符 AND OR  第一个不存在")
    private String logicalOperators;

    @ApiModelProperty(value = "运算符：>：gt； >=：gte； =：eq； <：lt； <=：lte； like：lk; between：bwe；hasAttr；attrValueChange")
    private String operator;

    @ApiModelProperty(value = "属性名称，如果是多级用 . 来表示；如：a.[b].c.[d].e  []表示为数组")
    private String attrName;

    @ApiModelProperty(value = "属性类型 long string decimal")
    private String attrType;

    @ApiModelProperty(value = "属性值")
    private String attrVal;

    @ApiModelProperty(value = "排序")
    private Integer sortNum;
}
