package com.xforceplus.janus.message.common.enums;


import javax.validation.constraints.NotNull;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/12 4:37 PM
 **/
public class CacheKey {
    /**
     * Redis cache key prefix used to prevent key collision on a shared redis
     */
    private static String REDIS_KEY_PREFIX = "MB_";

    private String JOINER_CHAR = "@#";

    private static String CHANNEL_TEMPLATE_KEY = REDIS_KEY_PREFIX + "CHANNEL_%s_%s";

    private static String PUB_CONFIG_KEY = REDIS_KEY_PREFIX + "PUB_CONFIG:%s";

    private static String MESSAGE_INFO_KEY = REDIS_KEY_PREFIX + "MESSAGE_INFO:%s";

    private static String CHANNEL_CONFIG_KEY = REDIS_KEY_PREFIX + "CHANNEL_CONFIG:%s";

    private static String SENSTIVE_WORD_EVENT_KEY = REDIS_KEY_PREFIX + "SENSTIVE_WORD_EVENT:%s";

    private static String SENSTIVE_WORD_SERVER_KEY = REDIS_KEY_PREFIX + "SENSTIVE_WORD_SERVER:%s_%s";

    public static String MESSAGE_SENDING = REDIS_KEY_PREFIX + "MESSAGE_SENDING";

    private static String APP_SECRET_KEY = REDIS_KEY_PREFIX + "APP_SEC:%s_%s";

    private static String APP_BUSINESS_KEY = REDIS_KEY_PREFIX + "APP_BUZ:%s";

    private static String APP_KEY_PUB_KEY = REDIS_KEY_PREFIX + "APP_KEY_PUB:%s";

    private static String APP_KEY_SUB_KEY = REDIS_KEY_PREFIX + "APP_KEY_SUB:%s";

    private static String ALL_APP_KEY_KEY = REDIS_KEY_PREFIX + "ALL_APP_KEY";

    /**
     * val 为 JSON String ：List<SubTag>
     */
    private static String SUB_TAG_KEY = REDIS_KEY_PREFIX + "SUB_TAG:%s";

    /**
     * val 为 当前最大的ID
     */
    private static String ID_BUSINESS_KEY = REDIS_KEY_PREFIX + "ID_BUSINESS:%s";

    /**
     * val 为 Sub entity dto
     */
    private static String SUB_CONFIG_KEY = REDIS_KEY_PREFIX + "SUB_CONFIG:%s";

    /**
     * val 为 JSON String ：List<PubTag>
     */
    private static String PUB_TAG_KEY = REDIS_KEY_PREFIX + "PUB_TAG:%s";

    private static String ALL_PUB_TAG_KEY = REDIS_KEY_PREFIX + "ALL_PUB_TAG";

    private static String ALL_PUB_CODE_KEY = REDIS_KEY_PREFIX + "ALL_PUB_CODE";

    private static String ALL_SUB_CODE_KEY = REDIS_KEY_PREFIX + "ALL_SUB_CODE";

    /**
     * key : pubCode
     * <p></p>
     * val 为 Set 存放的是：subCode
     */
    private static String SUB_CODE_OF_PUB_CODE_KEY = REDIS_KEY_PREFIX + "SUB_CODE_OF_PUB_CODE:%s";

    /**
     * key : subCode
     * <p></p>
     * val 为 List 存放的是：messageId
     */
    private static String MESSAGE_ID_OF_CONSUMER_KEY = REDIS_KEY_PREFIX + "MESSAGE_ID_OF_CONSUMER:%s";
    private static String MESSAGE_REPLAY_TASK_PREFIX = "MESSAGE_REPLAY_TASK:%s";
    private static String MESSAGE_REPLAY_TASK_LIST   = "MESSAGE_REPLAY_TASK_LIST";

    private static String PUB_EXCEPTION_KEY = REDIS_KEY_PREFIX + "PUB_EXCEPTION_KEY:%s";

    public static String getPubExceptionKey(String mqType) {
        return String.format(PUB_EXCEPTION_KEY, mqType);
    }

    public static String getMessageReplayTaskKey(String taskId) {
        return String.format(MESSAGE_REPLAY_TASK_PREFIX, taskId);
    }

    public static String getMessageReplayTaskListKey() {
        return MESSAGE_REPLAY_TASK_LIST;
    }

    public static String getMessageIdOfConsumerKey(String subCode) {
        return String.format(MESSAGE_ID_OF_CONSUMER_KEY, subCode);
    }


    public static String getSubCodeOfBusinessCodeKey(String pubCode) {
        return String.format(SUB_CODE_OF_PUB_CODE_KEY, pubCode);
    }


    public static String getChannelTemplateKey(@NotNull String appId, @NotNull String channelTemplateId) {
        return String.format(CHANNEL_TEMPLATE_KEY, appId, channelTemplateId);
    }

    public static String getPubConfig(@NotNull String pubCode) {
        return String.format(PUB_CONFIG_KEY, pubCode);
    }

    public static String getSenstiveWordKey(String eventId) {
        return String.format(SENSTIVE_WORD_EVENT_KEY, eventId);
    }

    public static String getServerOfSenstiveWordKey(String serverId, String eventId) {
        return String.format(SENSTIVE_WORD_SERVER_KEY, serverId, eventId);
    }

    /**
     * value为数组
     */
    public static String getAllPubCodeKey() {
        return ALL_PUB_CODE_KEY;
    }

    /**
     * value为数组
     */
    public static String getAllSubCodeKey() {
        return ALL_SUB_CODE_KEY;
    }

    public static String getMessageInfoKey(String messageId) {
        return String.format(MESSAGE_INFO_KEY, messageId);
    }

    public static String getChannelConfigKey(String channel) {
        return String.format(CHANNEL_CONFIG_KEY, channel);
    }

    public static String getAppSecretKey(String appId, String appSecret) {
        return String.format(APP_SECRET_KEY, appId, appSecret);
    }

    public static String getAppBusinessKey(String appId) {
        return String.format(APP_BUSINESS_KEY, appId);
    }

    public static String getSubTagKey(String subCode) {
        return String.format(SUB_TAG_KEY, subCode);
    }

    public static String getSubConfigKey(String subCode) {
        return String.format(SUB_CONFIG_KEY, subCode);
    }

    public static String getPubTagKey(String pubCode) {
        return String.format(PUB_TAG_KEY, pubCode);
    }

    public static String getALLPubTagKey() {
        return ALL_PUB_TAG_KEY;
    }

    public static String getAppKeyPubKey(String appKey) {
        return String.format(APP_KEY_PUB_KEY, appKey);
    }

    public static String getAppKeySubKey(String appKey) {
        return String.format(APP_KEY_SUB_KEY, appKey);
    }

    public static String getAllAppKeyKey() {
        return ALL_APP_KEY_KEY;
    }

    public static String getIdBusinessKey(String business) {
        return String.format(ID_BUSINESS_KEY, business);
    }
}
