/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils.id;

final class ShortIdGenerator {
    private static final long twepoch = 1288834974657L;
    private static final long workerIdBits = 0L;
    private static final long datacenterIdBits = 0L;
    private static final long sequenceBits = 0L;
    private static final long workerIdShift = 0L;
    private static final long datacenterIdShift = 0L;
    private static final long timestampLeftShift = 0L;
    private static final long sequenceMask = 0L;
    private static long lastTimestamp = -1L;
    private long sequence = 0L;
    private final long workerId = 0L;
    private final long datacenterId = 0L;

    ShortIdGenerator() {
    }

    protected synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id for " + (lastTimestamp - timestamp) + " milliseconds");
        }
        if (lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0L;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        lastTimestamp = timestamp;
        long nextId = timestamp - 1288834974657L << 0 | 0L | 0L | this.sequence;
        return nextId;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

