package com.xforceplus.janus.message.common.enums;

public enum RedisPubEnum {

    PUB("PUB", "发布"),

    PUB_TAG("PUB_TAG", "发布TAG"),

    SUB("SUB", "订阅"),

    SUB_TAG("SUB_TAG", "订阅TAG"),

    ;

    private String code;

    private String desc;

    RedisPubEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static RedisPubEnum getByCode(String code) {
        for (RedisPubEnum i : values()) {
            if (i.getCode().equals(code.toUpperCase())) {
                return i;
            }
        }
        return null;
    }

    public static RedisPubEnum getByCodeException(String code) {
        RedisPubEnum channelEnum = getByCode(code);
        if (channelEnum == null) {
            throw new IllegalArgumentException("RemoveCache枚举没有匹配到");
        }
        return channelEnum;
    }
    }
