package com.xforceplus.janus.message.common.enums;

public enum GroupPostingTaskStatusEnum {

    SUBMIT_PROCESSING(0, "提交处理中"),

    SUBMIT_PROCESS_SUCCESS(1, "提交处理成功"),

    REVOKED(10, "已撤销");

    private Integer code;

    private String desc;

    GroupPostingTaskStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static GroupPostingTaskStatusEnum getByCode(Integer code) {
        for (GroupPostingTaskStatusEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("消息状态没找到");
    }
}
