package com.xforceplus.janus.message.common.enums;

public enum TimeTypeEnum {

    HOUR("HOUR", "小时"),

    MINUTE("MINUTE", "分钟"),

    SECOND("SECOND", "秒"),
    ;

    private String code;

    private String desc;

    TimeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static TimeTypeEnum getByCode(String code) {
        for (TimeTypeEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("时间类型没找到");
    }
}
