package com.xforceplus.janus.message.common.dto.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.Instant;

/**
 * @author liuyao@xforceplus.com
 * @version 1.0
 * @date 2021/5/26 10:53
 */
@Data
public class ProcessSetDTO {

    @ApiModelProperty(value = "ID")
    private String id;

    @ApiModelProperty(value = "事件名称")
    private String name;

    @ApiModelProperty(value = "事件类型")
    private String type;

    @ApiModelProperty(value = "订阅标签表ID")
    private String subscriptionTagId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "是否有效")
    private Integer isValid = 1;

    @ApiModelProperty(value = "是否锁定")
    private Integer isLock = 0;

    @ApiModelProperty(value = "创建者")
    private String creator;

    @ApiModelProperty(value = "创建时间")
    private Instant createdTime;

    @ApiModelProperty(value = "更新者")
    private String modifier;

    @ApiModelProperty(value = "更新时间")
    private Instant modifiedTime;
}
