package com.xforceplus.janus.message.common.enums;

public enum MessageStatusEnum {

    WAIT_STORAGE(1, "待存储"),

    WAIT_PROCESS(10, "待处理"),

    PROCESSING(20, "处理中"),

    SENDING(30, "分发中"),

    PART_OVER(40, "部分完成"),

    OVER(50, "完成");

    private Integer code;

    private String desc;

    MessageStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static MessageStatusEnum getByCode(Integer code) {
        for (MessageStatusEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("消息状态没找到");
    }
}
