package com.xforceplus.janus.message.common.utils;

import java.util.concurrent.*;

public class MessageStaticThreadPoolUtils {

    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(4, 8, 60, TimeUnit.SECONDS, new ArrayBlockingQueue<>(256));

    public static void execute(Runnable runnable) {
        EXECUTOR.execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> runnable) {
        return EXECUTOR.submit(runnable);
    }

}
