/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cglib.beans.BeanCopier;

public class XBeanUtils<S, T> {
    public static Map<String, BeanCopier> beanCopierMap = new ConcurrentHashMap<String, BeanCopier>();

    public static <S, T> T copyBean(S source, Class<T> modelClass) throws IllegalAccessException, InstantiationException {
        if (source == null) {
            return null;
        }
        String beanKey = XBeanUtils.generateKey(source.getClass(), modelClass);
        BeanCopier copier = null;
        if (!beanCopierMap.containsKey(beanKey)) {
            copier = BeanCopier.create(source.getClass(), modelClass, (boolean)false);
            beanCopierMap.put(beanKey, copier);
        } else {
            copier = beanCopierMap.get(beanKey);
        }
        T model = modelClass.newInstance();
        copier.copy(source, model, null);
        return model;
    }

    public static <S, T> T copyBeanNoException(S source, Class<T> modelClass) {
        T model = null;
        try {
            model = XBeanUtils.copyBean(source, modelClass);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static <F, T> List<T> copyListBean(List<F> fromList, Class<T> tClass) throws InstantiationException, IllegalAccessException {
        if (fromList.isEmpty() || fromList == null) {
            return null;
        }
        ArrayList<T> tList = new ArrayList<T>();
        for (F f : fromList) {
            T t = XBeanUtils.copyBean(f, tClass);
            tList.add(t);
        }
        return tList;
    }

    private static String generateKey(Class<?> class1, Class<?> class2) {
        return class1.toString() + class2.toString();
    }
}

