package com.xforceplus.janus.message.common.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ThreadPoolAcceptRequestUtils {

    public static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(128, 256, 60, TimeUnit.SECONDS, new ArrayBlockingQueue<>(256), new CustomerThreadFactory("accept-request"), new ThreadPoolExecutor.CallerRunsPolicy());

    public static void execute(Runnable runnable) {
        EXECUTOR.execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> runnable) {
        return EXECUTOR.submit(runnable);
    }

}
