package com.xforceplus.janus.message.common.utils;

import java.util.concurrent.*;

public class ThreadPoolUtils {

    public static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(16, 32, 60, TimeUnit.SECONDS, new ArrayBlockingQueue<>(2048),new CustomerThreadFactory("msg-distribution"));

    public static void execute(Runnable runnable) {
        EXECUTOR.execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> runnable) {
        return EXECUTOR.submit(runnable);
    }

}
