package com.xforceplus.janus.message.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 消息回执对象
 *
 * @author 许传厚@xforceplus.com
 * @date 2021/3/11 2:53 PM
 **/
@ApiModel("消息回执对象")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MessageAck implements Serializable {

    @ApiModelProperty(value = "回执标记ID", required = true)
    private String receiptHandle;
    @ApiModelProperty(value = "MQ_type", required = true)
    private String mqType;
    @ApiModelProperty(value = "MQ集群编码", required = true)
    private String mqClusterCode;
    @ApiModelProperty(value = "topic", required = true)
    private String topicName;
    @ApiModelProperty(value = "订阅appKey", required = true)
    private String subAppKey;
    @ApiModelProperty(value = "发布者appKey")
    private String pubAppKey;
    @ApiModelProperty(value = "发布代码")
    private String pubCode;
    @ApiModelProperty(value = "消息ID", example = "消息总线")
    private Long messageId;
    @ApiModelProperty(value = "第三方消息ID", example = "RocketMQ,SQS")
    private String thirdPartyId;

    public MessageAck() {

    }

    public String getConsumerKey() {
        return this.topicName + subAppKey;
    }

}
