package com.xforceplus.janus.message.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 响应消息
 *
 * @author zhujie@xforceplus.com
 * @date 2021/3/3 2:53 PM
 **/
@ApiModel("MQ响应消息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MqResponseMessage extends ResponseMessage implements Serializable {

    @ApiModelProperty(value = "businessNo")
    private String uniqueId;

    @ApiModelProperty(value = "消息来源ID,pubsub、sqs、自己的")
    private String sourceMessageId;

    @ApiModelProperty(value = "是否回放消息 0否 1是")
    private Integer isPlayMessage;

}
