package com.xforceplus.janus.message.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/22 4:30 PM
 **/
public class GenericBuilder<T> {

    private final Supplier<T> instantiator;
    private final List<Consumer<T>> instanceModifiers = new ArrayList();

    protected GenericBuilder(Supplier<T> instantiator) {
        this.instantiator = instantiator;
    }

    public static final <T> GenericBuilder<T> of(Supplier<T> instantiator) {
        return new GenericBuilder(instantiator);
    }

    public <U> GenericBuilder<T> withNonnull(BiConsumer<T, U> consumer, U value) {
        return value != null ? this.with(consumer, value) : this;
    }

    public <U> GenericBuilder<T> with(boolean condition, BiConsumer<T, U> consumer, U value) {
        if (condition) {
            with(consumer, value);
        }
        return this;
    }

    public <U> GenericBuilder<T> with(BiConsumer<T, U> consumer, U value) {
        Consumer<T> instanceModifier = (instance) -> {
            consumer.accept(instance, value);
        };
        this.instanceModifiers.add(instanceModifier);
        return this;
    }

    public T build() {
        T instance = this.instantiator.get();
        this.instanceModifiers.forEach((modifier) -> {
            modifier.accept(instance);
        });
        this.instanceModifiers.clear();
        return instance;
    }
}
