package com.xforceplus.janus.message.common.utils;

import com.xforceplus.apollo.utils.ErrorUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/11/22 5:02 PM
 **/
public class ZipUtil {

    private static final Logger log = LoggerFactory.getLogger(ZipUtil.class);

    public ZipUtil() {
    }

    public static String gzip(String primStr) {
        if (primStr != null && primStr.length() != 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = null;

            try {
                gzip = new GZIPOutputStream(out);
                gzip.write(primStr.getBytes());
            } catch (IOException var12) {
                var12.printStackTrace();
            } finally {
                if (gzip != null) {
                    try {
                        gzip.close();
                    } catch (IOException var11) {
                        log.error(ErrorUtil.getStackMsg(var11));
                    }
                }

            }

            return (new BASE64Encoder()).encode(out.toByteArray());
        } else {
            return primStr;
        }
    }

    public static String ungzip(String compressedStr) {
        if (compressedStr == null) {
            return null;
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = null;
            GZIPInputStream ginzip = null;
            byte[] compressed = null;
            String decompressed = null;

            try {
                compressed = (new BASE64Decoder()).decodeBuffer(compressedStr);
                in = new ByteArrayInputStream(compressed);
                ginzip = new GZIPInputStream(in);
                byte[] buffer = new byte[1024];
                boolean var7 = true;

                int offset;
                while((offset = ginzip.read(buffer)) != -1) {
                    out.write(buffer, 0, offset);
                }

                decompressed = out.toString();
            } catch (IOException var24) {
                var24.printStackTrace();
            } finally {
                if (ginzip != null) {
                    try {
                        ginzip.close();
                    } catch (IOException var23) {
                        ;
                    }
                }

                if (in != null) {
                    try {
                        in.close();
                    } catch (IOException var22) {
                        log.error(ErrorUtil.getStackMsg(var22));
                    }
                }

                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException var21) {
                        log.error(ErrorUtil.getStackMsg(var21));
                    }
                }

            }

            return decompressed;
        }
    }

    public static final String zip(String str) {
        if (str == null) {
            return null;
        } else {
            ByteArrayOutputStream out = null;
            ZipOutputStream zout = null;
            String compressedStr = null;

            try {
                out = new ByteArrayOutputStream();
                zout = new ZipOutputStream(out);
                zout.putNextEntry(new ZipEntry("0"));
                zout.write(str.getBytes());
                zout.closeEntry();
                byte[] compressed = out.toByteArray();
                compressedStr = (new BASE64Encoder()).encodeBuffer(compressed);
            } catch (IOException var18) {
                log.error(ErrorUtil.getStackMsg(var18));
                Object var1 = null;
            } finally {
                if (zout != null) {
                    try {
                        zout.close();
                    } catch (IOException var17) {
                        log.error(ErrorUtil.getStackMsg(var17));
                    }
                }

                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException var16) {
                        log.error(ErrorUtil.getStackMsg(var16));
                    }
                }

            }

            return compressedStr;
        }
    }

    public static final String unzip(String compressedStr) {
        if (compressedStr == null) {
            return null;
        } else {
            ByteArrayOutputStream out = null;
            ByteArrayInputStream in = null;
            ZipInputStream zin = null;
            String decompressed = null;

            try {
                byte[] compressed = (new BASE64Decoder()).decodeBuffer(compressedStr);
                out = new ByteArrayOutputStream();
                in = new ByteArrayInputStream(compressed);
                zin = new ZipInputStream(in);
                zin.getNextEntry();
                byte[] buffer = new byte[1024];
                boolean var7 = true;

                int offset;
                while((offset = zin.read(buffer)) != -1) {
                    out.write(buffer, 0, offset);
                }

                decompressed = out.toString();
            } catch (IOException var24) {
                log.error(ErrorUtil.getStackMsg(var24));
                decompressed = null;
            } finally {
                if (zin != null) {
                    try {
                        zin.close();
                    } catch (IOException var23) {
                        log.error(ErrorUtil.getStackMsg(var23));
                    }
                }

                if (in != null) {
                    try {
                        in.close();
                    } catch (IOException var22) {
                        log.error(ErrorUtil.getStackMsg(var22));
                    }
                }

                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException var21) {
                        log.error(ErrorUtil.getStackMsg(var21));
                    }
                }

            }

            return decompressed;
        }
    }
}
