package com.xforceplus.janus.message.common.utils.id;


import com.xforceplus.janus.message.common.utils.NetworkUtils;
import org.apache.commons.lang3.StringUtils;

import static org.apache.commons.lang3.StringUtils.substring;

public abstract class IdGenerator {
    private static final ShortIdGenerator SHORT_ID_GENERATOR = new ShortIdGenerator();
    private static final IdWorker ID_WORKER = new IdWorker();
    private static final String           IP_SUFFIX          = substring(NetworkUtils.INTRANET_IP.replaceAll(".", StringUtils.EMPTY), -3);

    /**
     * Generate a thread-safe digit format ID
     *
     * @return 19 bits length，e.g：1672888135850179037
     */
    public static long generateTimestampId() {
        return ID_WORKER.nextId();
    }

    /**
     * Generate a thread-safe digit format ID, it can be used in a low concurrency environment
     *
     * @return 12 bits length，e.g：306554419571
     */
    @Deprecated
    public static long generateShortId() {
        return SHORT_ID_GENERATOR.nextId();
    }

    /**
     * Generate a 20 bits format ID
     *
     * @return 20 bits length，e.g：R1672888135850179037
     */
    public static String generateRequestId() {
        return "R" + generateTimestampId();
    }

    /**
     * Generate a thread-safe digit format ID string with unique value under multiple hosts cluster environment
     * The first three bits are the IP suffix
     *
     * @return 22 bits length，e.g：1281672888135850179037
     */
    public static String generateUniqueId() {
        return IP_SUFFIX + generateTimestampId();
    }

}
