/**
 * <p>Title: liteflow</p>
 * <p>Description: 轻量级的组件式流程框架</p>
 *
 * @author Bryan.Zhang
 * @email weenyc31@163.com
 * @Date 2020/4/1
 */
package com.xforceplus.janus.message.event.flow.core.flow;

import com.xforceplus.janus.message.common.enums.NodeTypeEnum;

import java.text.MessageFormat;

import lombok.Data;

@Data
public class CmpStep {

    private String eventId;

    private String requestId;

    private NodeTypeEnum stepEventType;

    public CmpStep(String eventId, String requestId, NodeTypeEnum stepType) {
        this.eventId = eventId;
        this.requestId = requestId;
        this.stepEventType = stepType;
    }

    @Override
    public String toString() {
        return MessageFormat.format("({0}){1}({2})", requestId, eventId, stepEventType.getCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        } else {
            if (getClass() != obj.getClass()) {
                return false;
            } else {
                if (((CmpStep) obj).getEventId().equals(this.getEventId())) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }
}
