package com.xforceplus.janus.message.event.flow.core;

import com.alibaba.fastjson.JSON;
import com.aliyun.mq.http.model.Message;
import com.xforceplus.janus.message.common.dto.ResponseMessage;
import com.xforceplus.janus.message.common.enums.XMessageMQTypeEnum;
import com.xforceplus.janus.message.core.mq.XMessageProcessor;
import com.xforceplus.janus.message.core.mq.XMessage;
import com.xforceplus.janus.message.event.flow.core.data.Slot;
import com.xforceplus.janus.message.event.flow.core.data.DefaultSlot;
import com.xforceplus.janus.message.event.flow.core.flow.Flow;
import com.xforceplus.janus.message.event.flow.core.exception.FlowNotFoundException;
import com.xforceplus.janus.message.event.flow.core.exception.NoAvailableSlotException;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.text.MessageFormat;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/14 3:48 PM
 **/
@Component("flowExecutor")
@Slf4j
public class FlowExecutor implements XMessageProcessor {

    public <T extends Slot> T execute(String flowId, Object param) throws Exception {
        return execute(flowId, param, DefaultSlot.class, null, false);
    }

    public <T extends Slot> T execute(String flowId, Object param, Class<? extends Slot> slotClazz) throws Exception {
        return execute(flowId, param, slotClazz, null, false);
    }

    public void invoke(String flowId, Object param, Class<? extends Slot> slotClazz, Integer slotIndex) throws Exception {
        execute(flowId, param, slotClazz, slotIndex, true);
    }

    public <T extends Slot> T execute(String flowId, Object param, Class<? extends Slot> slotClazz, Integer slotIndex, boolean isChildFlow) throws Exception {
        Slot slot = null;

        Flow flow = FlowBus.getFlowById(flowId);

        if (flow == null) {
            String errorMsg = MessageFormat.format("couldn't find chain with the id[{0}]", flowId);
            throw new FlowNotFoundException(errorMsg);
        }

        if (!isChildFlow && slotIndex == null) {
            slotIndex = SlotBus.offerSlot(slotClazz);
            log.info("slot[{}] offered", slotIndex);
        }

        if (slotIndex == -1) {
            throw new NoAvailableSlotException("there is no available slot");
        }

        slot = SlotBus.getSlot(slotIndex);
        if (slot == null) {
            throw new NoAvailableSlotException("the slot is not exist");
        }

        if (StringUtils.isBlank(slot.getRequestId())) {
            slot.generateRequestId();
            log.info("requestId[{}] has generated", slot.getRequestId());
        }

        if (!isChildFlow) {
            slot.setRequestData(param);
            slot.setFlowId(flowId);
        } else {
            // TODO: 2020/12/17 暂时不考虑子流程
        }


        try {
            //执行flow
            flow.execute(slotIndex);
        } catch (Exception e) {
            slot.setSuccess(false);
            slot.setErrorMsg(e.getMessage());
        } finally {
            if (!isChildFlow) {
                slot.printStep();
                SlotBus.releaseSlot(slotIndex);
            }
        }
        return (T) slot;
    }

    @Override
    public void process(XMessage message) throws Exception {
        if (message.getMqType().equals(XMessageMQTypeEnum.ROCKET_MQ.getCode())) {
            Message rocketMessage = (Message) message.getMqMsg();
            ResponseMessage originMessage = null;
            try {
                originMessage = JSON.parseObject(new String(rocketMessage.getMessageBodyBytes()), ResponseMessage.class);
            } catch (Exception e) {
                e.printStackTrace();
            }
            originMessage.setId(rocketMessage.getMessageId());
            System.out.println("==============");
            System.out.println("==============");
            System.out.println("==============");
            execute(originMessage.getPubCode(), originMessage);
        }
    }
}
