package com.xforceplus.janus.message.event.flow.core.flow;


import com.xforceplus.janus.message.common.enums.NodeTypeEnum;
import com.xforceplus.janus.message.event.flow.core.AbsNodeExecutor;
import com.xforceplus.janus.message.event.flow.core.FlowExecutor;
import com.xforceplus.janus.message.event.flow.core.data.Slot;
import com.xforceplus.janus.message.event.flow.core.SlotBus;
import com.xforceplus.janus.message.event.flow.core.exception.FlowSystemException;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: gateway-ops->JanusFlow
 * @description: 数据流信息
 * @author: xuchuanhou
 * @create: 2020-06-06 15:08
 **/
@Data
@ToString
@Slf4j
public class Flow {

    private String id;

    private String name;

    @Valid
    @NotNull(message = "流程节点不能为空")
    private List<Node> nodeList;

    public Flow(String id, String name, @Valid @NotNull(message = "流程节点不能为空") List<Node> nodeList) {
        this.id = id;
        this.name = name;
        this.nodeList = nodeList;
    }

    public void execute(Integer slotIndex) throws Exception {
        if (CollectionUtils.isEmpty(nodeList)) {
            throw new FlowSystemException("no nodeList in this flow [" + name + "] ,id [" + id + "]");
        }

        Slot slot = SlotBus.getSlot(slotIndex);


        for (Node node : nodeList) {
            if (slot.isEnd()) {
                log.warn("event process early interrupt requestId : {} ", slot.getRequestId());
                break;
            }
            AbsNodeExecutor executor = AbsNodeExecutor.nodeType2Executor.get(node.getNodeType());
//        executor.setMonitorBus(MonitorFactory.getInstance());
            executor.setSlotIndex(slotIndex).execute(node);
        }
    }

    /**
     * 通过id获取节点
     */
    public Node getNodeModel(String nodeId) {
        if (null == nodeList || nodeList.isEmpty()) {
            return null;
        }
        for (Node node : nodeList) {
            if (node.getId().equals(nodeId)) {
                return node;
            }
        }
        return null;
    }

}
