package com.xforceplus.janus.message.event.flow.core;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.common.enums.NodeTypeEnum;
import com.xforceplus.janus.message.event.flow.core.data.Slot;
import com.xforceplus.janus.message.event.flow.core.flow.CmpStep;
import com.xforceplus.janus.message.event.flow.core.flow.Node;
import com.xforceplus.janus.message.monitor.MonitorBus;

import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/14 10:24 AM
 **/
@Slf4j
public abstract class AbsNodeExecutor {

    @Autowired
    MonitorBus monitorBus;

    {
        nodeType2Executor.put(getNodeType(), this);
    }

    private InheritableThreadLocal<Integer> slotIndexTL = new InheritableThreadLocal<Integer>();

    private InheritableThreadLocal<Node> nodeTL = new InheritableThreadLocal<Node>();

    public static Map<String, AbsNodeExecutor> nodeType2Executor = new HashMap<>();

    public void execute(Node node) throws Exception {
        Slot slot = this.getSlot();
        slot.setCurrNodeId(node.getId());
        nodeTL.set(node);

        log.info("nodeId{}[{}]:[O]start component[{}],nodeJson[{}] execution", node.getId(), slot.getRequestId(),
                this.getClass().getSimpleName(), JacksonUtil.getInstance().toJson(node));
        slot.addStep(new CmpStep(node.getId(), slot.getRequestId(), NodeTypeEnum.getByCode(getNodeType())));

        StopWatch stopWatch = new StopWatch();
        stopWatch.start();

        // process前置处理

        process();

        // process后置处理

        stopWatch.stop();
        long timeSpent = stopWatch.getTime();

//        MessageStatistics statistics = new MessageStatistics();
//        statistics.setMessageId(Long.valueOf(((ResponseMessage) slot.getRequestData()).getId()));
//        statistics.setRequestId(slot.getRequestId());
//        statistics.setEventId(slot.getFlowId());
//        statistics.setProcessStep(getNodeType());
//        statistics.setTimeSpent(timeSpent);
//        statistics.setInsertTime(Instant.now());
//
//        monitorBus.addStatistics(statistics);

        log.info("[{}]:componnet[{}] finished in {} milliseconds", getSlotIndex(), this.getClass().getSimpleName(),
                timeSpent);
    }


    public <T extends Slot> T getSlot() {
        return SlotBus.getSlot(this.slotIndexTL.get());
    }

    public Integer getSlotIndex() {
        return this.slotIndexTL.get();
    }

    public abstract String getNodeType();

    public AbsNodeExecutor setSlotIndex(Integer slotIndex) {
        this.slotIndexTL.set(slotIndex);
        return this;
    }

    /**
     * 返回nextNodeId
     */
    public abstract void process() throws Exception;

    public Node getCurrNode() {
        return nodeTL.get();
    }

    public void setCurrNode(Node node) {
        nodeTL.set(node);
    }
}
