package com.xforceplus.janus.message.event.flow.core;

import com.xforceplus.janus.message.event.flow.core.flow.Flow;
import com.xforceplus.janus.message.event.flow.core.flow.Node;

import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import lombok.extern.slf4j.Slf4j;

/**
 * 事件总线
 *
 * @author zhujie@xforceplus.com
 * @date 2021/1/14 10:37 AM
 **/
@Slf4j
public class FlowBus {

    private static Map<String, Flow> flowMap = new ConcurrentHashMap<>();

    private static Map<String, Node> nodeMap = new ConcurrentHashMap<>();

    private static Map<String, List<Node>> flowId2Nodes = new ConcurrentHashMap<>();

    private static InheritableThreadLocal<List<Node>> executingNodeMap = new InheritableThreadLocal<List<Node>>();

    public static Flow getFlowById(String flowId) throws Exception {
        if (flowMap == null || flowMap.isEmpty()) {
            throw new Exception("please config the flow first,flowId : " + flowId);
        }
        List<Node> nodes = flowId2Nodes.get(flowId);
        if (CollectionUtils.isNotEmpty(nodes)) {
            executingNodeMap.set(nodes);
            return flowMap.get(flowId);
        } else {
            throw new Exception("please config the flow's node first,flowId : " + flowId);
        }
    }

    public static Node getExecutingNodeById(String nodeId) {
        List<Node> nodes = executingNodeMap.get();
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (Node node : nodes) {
                if (node.getId().equals(nodeId)) {
                    return node;
                }
            }

        }
        log.error("nodes not empty ,can not find node ,nodeId :{}", nodeId);
        return null;
    }

    public static void saveOrUpdate(Flow flow, List<Node> nodes) {
        flowMap.put(flow.getId(), flow);
        List<Node> originNodes = flowId2Nodes.get(flow.getId());
        if (CollectionUtils.isNotEmpty(originNodes)) {
            for (Node node : originNodes) {
                nodeMap.remove(node.getId());
            }
        }

        for (Node node : nodes) {
            nodeMap.put(node.getId(), node);
        }
        flowId2Nodes.put(flow.getId(), nodes);

    }

    public static boolean containFlow(String flowId) {
        return flowMap.containsKey(flowId);
    }

    public static boolean containNode(String nodeId) {
        return nodeMap.containsKey(nodeId);
    }
}
