package com.xforceplus.janus.message.event.flow.core;

import com.xforceplus.janus.message.event.flow.core.data.Slot;

import java.util.concurrent.atomic.AtomicInteger;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/14 2:37 PM
 **/
@Slf4j
public class SlotBus {

    public static final int SLOT_SIZE = 1024;

    public static AtomicInteger OCCUPY_COUNT = new AtomicInteger(0);

    private static Slot[] slots = new Slot[SLOT_SIZE];

    public synchronized static int offerSlot(Class<? extends Slot> slotClazz){
        try{
            for(int i = 0; i < slots.length; i++){
                if(slots[i] == null){
                    slots[i] = slotClazz.newInstance();
                    OCCUPY_COUNT.incrementAndGet();
                    return i;
                }
            }
        }catch(Exception e){
            log.error("offer slot error",e);
            return -1;
        }
        return -1;
    }

    @SuppressWarnings("unchecked")
    public static <T extends Slot> T getSlot(int slotIndex){
        return (T)slots[slotIndex];
    }

    public static void releaseSlot(int slotIndex){
        if(slots[slotIndex] != null){
            log.info("[{}]:slot[{}] released",slots[slotIndex].getRequestId(),slotIndex);
            slots[slotIndex] = null;
            OCCUPY_COUNT.decrementAndGet();
        }else{
            log.warn("slot[{}] already has been released",slotIndex);
        }
    }
}
