/**
 * <p>
 * Title: liteflow
 * </p>
 * <p>
 * Description: 轻量级的组件式流程框架
 * </p>
 *
 * @author Bryan.Zhang
 * @email weenyc31@163.com
 * @Date 2020/4/1
 */
package com.xforceplus.janus.message.event.flow.core.data;

import com.xforceplus.janus.message.event.flow.core.flow.CmpStep;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@SuppressWarnings("unchecked")
public abstract class AbsSlot implements Slot {

    public static final String REQUEST = "request";

    private final String RESPONSE = "response";

    private final String COND_NODE_PREFIX = "cond_";

    private final String NODE_INPUT_PREFIX = "input_";

    private final String NODE_OUTPUT_PREFIX = "output_";

    private final String REQUEST_ID = "req_id";

    private final String FLOW_ID = "flow_id";

    private boolean isSuccess = true;

    private boolean isStart = false;

    private boolean isEnd = false;

    private String errorMsg;

    private String currNodeId;

    private String nextNodeId;

    private Deque<CmpStep> executeSteps = new ArrayDeque<CmpStep>();

    protected ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap<String, Object>();

    @Override
    public <T> T getInput(String nodeId) {
        return (T) dataMap.get(NODE_INPUT_PREFIX + nodeId);
    }

    @Override
    public <T> T getOutput(String nodeId) {
        return (T) dataMap.get(NODE_OUTPUT_PREFIX + nodeId);
    }

    @Override
    public <T> void setInput(String nodeId, T t) {
        dataMap.put(NODE_INPUT_PREFIX + nodeId, t);
    }

    @Override
    public <T> void setOutput(String nodeId, T t) {
        dataMap.put(NODE_OUTPUT_PREFIX + nodeId, t);
    }

    @Override
    public <T> T getRequestData() {
        return (T) dataMap.get(REQUEST);
    }

    @Override
    public <T> void setRequestData(T t) {
        dataMap.put(REQUEST, t);
    }

    @Override
    public <T> T getResponseData() {
        return (T) dataMap.get(RESPONSE);
    }

    @Override
    public <T> void setResponseData(T t) {
        dataMap.put(RESPONSE, t);
    }

    @Override
    public <T> T getData(String key) {
        return (T) dataMap.get(key);
    }

    @Override
    public <T> void setData(String key, T t) {
        dataMap.put(key, t);
    }

    @Override
    public void addStep(CmpStep step) {
        this.executeSteps.add(step);
    }

    @Override
    public void setFlowId(String flowId) {
        dataMap.put(FLOW_ID, flowId);
    }

    @Override
    public String getFlowId() {
        return (String) dataMap.get(FLOW_ID);
    }

    @Override
    public void printStep() {
        StringBuffer str = new StringBuffer();
        CmpStep cmpStep = null;
        for (Iterator<CmpStep> it = executeSteps.iterator(); it.hasNext(); ) {
            cmpStep = it.next();
            str.append(cmpStep);
            if (it.hasNext()) {
                str.append("==>");
            }
        }
        log.info("[{}]:FLOW_NAME[{}]\n{}", getRequestId(), this.getFlowId(), str.toString());
    }

    @Override
    public void generateRequestId() {
        dataMap.put(REQUEST_ID, new Long(System.nanoTime()).toString());
    }

    @Override
    public String getRequestId() {
        return (String) dataMap.get(REQUEST_ID);
    }

    public Deque<CmpStep> getExecuteSteps() {
        return executeSteps;
    }

    @Override
    public boolean isSuccess() {
        return isSuccess;
    }

    @Override
    public void setSuccess(boolean success) {
        isSuccess = success;
    }

    @Override
    public String getErrorMsg() {
        return errorMsg;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public String getCurrNodeId() {
        return currNodeId;
    }

    @Override
    public void setCurrNodeId(String currNodeId) {
        this.currNodeId = currNodeId;
    }

    @Override
    public void setEnd(boolean end) {
        this.isEnd = end;
    }

    @Override
    public boolean isEnd() {
        return this.isEnd;
    }
}
