package com.xforceplus.janus.message.event.flow.core.flow;

import java.io.Serializable;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 节点
 */
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class Node<T> implements Serializable {

    /**
     * 节点id
     */
    @NonNull
    private String id;

    /**
     * 流程id
     */
    @NonNull
    private String flowId;

    /**
     * 节点名称
     */
    @NonNull
    private String name;
    /**
     * 节点类型
     */
    @NonNull
    private String nodeType;
    /**
     * 下一个节点id
     */
    private String nextNodeId;

    /**
     * 版本
     */
    private String version;

    /**
     * 扩展配置
     */
    private T config;

    public void execute(){

    }

}
