/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.event.flow.core;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.common.enums.NodeTypeEnum;
import com.xforceplus.janus.message.event.flow.core.SlotBus;
import com.xforceplus.janus.message.event.flow.core.data.Slot;
import com.xforceplus.janus.message.event.flow.core.flow.CmpStep;
import com.xforceplus.janus.message.event.flow.core.flow.Node;
import com.xforceplus.janus.message.monitor.MonitorBus;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbsNodeExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbsNodeExecutor.class);
    @Autowired
    MonitorBus monitorBus;
    private InheritableThreadLocal<Integer> slotIndexTL;
    private InheritableThreadLocal<Node> nodeTL;
    public static Map<String, AbsNodeExecutor> nodeType2Executor = new HashMap<String, AbsNodeExecutor>();

    public AbsNodeExecutor() {
        nodeType2Executor.put(this.getNodeType(), this);
        this.slotIndexTL = new InheritableThreadLocal();
        this.nodeTL = new InheritableThreadLocal();
    }

    public void execute(Node node) throws Exception {
        Object slot = this.getSlot();
        slot.setCurrNodeId(node.getId());
        this.nodeTL.set(node);
        log.info("nodeId{}[{}]:[O]start component[{}],nodeJson[{}] execution", new Object[]{node.getId(), slot.getRequestId(), this.getClass().getSimpleName(), JacksonUtil.getInstance().toJson((Object)node)});
        slot.addStep(new CmpStep(node.getId(), slot.getRequestId(), NodeTypeEnum.getByCode((String)this.getNodeType())));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.process();
        stopWatch.stop();
        long timeSpent = stopWatch.getTime();
        log.info("[{}]:componnet[{}] finished in {} milliseconds", new Object[]{this.getSlotIndex(), this.getClass().getSimpleName(), timeSpent});
    }

    public <T extends Slot> T getSlot() {
        return SlotBus.getSlot((Integer)this.slotIndexTL.get());
    }

    public Integer getSlotIndex() {
        return (Integer)this.slotIndexTL.get();
    }

    public abstract String getNodeType();

    public AbsNodeExecutor setSlotIndex(Integer slotIndex) {
        this.slotIndexTL.set(slotIndex);
        return this;
    }

    public abstract void process() throws Exception;

    public Node getCurrNode() {
        return (Node)this.nodeTL.get();
    }

    public void setCurrNode(Node node) {
        this.nodeTL.set(node);
    }
}

