/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.event.flow.core;

import com.xforceplus.janus.message.entity.ProcessNode;
import com.xforceplus.janus.message.event.flow.core.flow.Flow;
import com.xforceplus.janus.message.event.flow.core.flow.Node;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowBus {
    private static final Logger log = LoggerFactory.getLogger(FlowBus.class);
    private static final Map<String, Flow<ProcessNode>> FLOW_MAP = new ConcurrentHashMap<String, Flow<ProcessNode>>();
    private static final Map<String, Node<ProcessNode>> NODE_MAP = new ConcurrentHashMap<String, Node<ProcessNode>>();
    private static final Map<String, List<Node<ProcessNode>>> FLOW_ID_2_NODES = new ConcurrentHashMap<String, List<Node<ProcessNode>>>();
    private static final InheritableThreadLocal<List<Node<ProcessNode>>> EXECUTING_NODE_MAP = new InheritableThreadLocal();

    public static Flow<ProcessNode> getFlowById(String flowId) {
        Validate.validState((boolean)MapUtils.isNotEmpty(FLOW_MAP), (String)("Please configure the flow [" + flowId + "] before use!"), (Object[])new Object[0]);
        List<Node<ProcessNode>> nodes = FLOW_ID_2_NODES.get(flowId);
        Validate.validState((boolean)CollectionUtils.isNotEmpty(nodes), (String)("Please configure the nodes of flow [" + flowId + "] before use!"), (Object[])new Object[0]);
        EXECUTING_NODE_MAP.set(nodes);
        return FLOW_MAP.get(flowId);
    }

    public static Node<ProcessNode> getExecutingNodeById(String nodeId) {
        List nodes = (List)EXECUTING_NODE_MAP.get();
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            for (Node node : nodes) {
                if (!node.getId().equals(nodeId)) continue;
                return node;
            }
        }
        log.error("nodes not empty ,can not find node ,nodeId :{}", (Object)nodeId);
        return null;
    }

    public static void saveOrUpdate(Flow<ProcessNode> flow, List<Node<ProcessNode>> nodes) {
        FLOW_MAP.put(flow.getId(), flow);
        List<Node<ProcessNode>> originNodes = FLOW_ID_2_NODES.get(flow.getId());
        if (CollectionUtils.isNotEmpty(originNodes)) {
            for (Node<ProcessNode> node : originNodes) {
                NODE_MAP.remove(node.getId());
            }
        }
        for (Node<ProcessNode> node : nodes) {
            NODE_MAP.put(node.getId(), node);
        }
        FLOW_ID_2_NODES.put(flow.getId(), nodes);
    }

    public static boolean containFlow(String flowId) {
        return FLOW_MAP.containsKey(flowId);
    }

    public static boolean containNode(String nodeId) {
        return NODE_MAP.containsKey(nodeId);
    }
}

