/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.event.flow.core;

import com.xforceplus.janus.message.common.dto.ResponseMessage;
import com.xforceplus.janus.message.core.mq.XMessageProcessor;
import com.xforceplus.janus.message.entity.ProcessNode;
import com.xforceplus.janus.message.event.flow.core.FlowBus;
import com.xforceplus.janus.message.event.flow.core.SlotBus;
import com.xforceplus.janus.message.event.flow.core.data.DefaultSlot;
import com.xforceplus.janus.message.event.flow.core.data.Slot;
import com.xforceplus.janus.message.event.flow.core.exception.FlowNotFoundException;
import com.xforceplus.janus.message.event.flow.core.exception.NoAvailableSlotException;
import com.xforceplus.janus.message.event.flow.core.flow.Flow;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="flowExecutor")
public class FlowExecutor
implements XMessageProcessor {
    private static final Logger log = LoggerFactory.getLogger(FlowExecutor.class);

    public <T extends Slot> T execute(String flowId, Object param) throws Exception {
        return this.execute(flowId, param, DefaultSlot.class, null, false);
    }

    public <T extends Slot> T execute(String flowId, Object param, Class<? extends Slot> slotClazz) throws Exception {
        return this.execute(flowId, param, slotClazz, null, false);
    }

    public void invoke(String flowId, Object param, Class<? extends Slot> slotClazz, Integer slotIndex) throws Exception {
        this.execute(flowId, param, slotClazz, slotIndex, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Slot> T execute(String flowId, Object param, Class<? extends Slot> slotClazz, Integer slotIndex, boolean isChildFlow) throws Exception {
        Slot slot = null;
        Flow<ProcessNode> flow = FlowBus.getFlowById(flowId);
        if (flow == null) {
            String errorMsg = MessageFormat.format("couldn't find chain with the id[{0}]", flowId);
            throw new FlowNotFoundException(errorMsg);
        }
        if (!isChildFlow && slotIndex == null) {
            slotIndex = SlotBus.offerSlot(slotClazz);
            log.info("slot[{}] offered", (Object)slotIndex);
        }
        if (slotIndex == -1) {
            throw new NoAvailableSlotException("there is no available slot");
        }
        slot = (Slot)SlotBus.getSlot(slotIndex);
        if (slot == null) {
            throw new NoAvailableSlotException("the slot is not exist");
        }
        if (StringUtils.isBlank((CharSequence)slot.getRequestId())) {
            slot.generateRequestId();
            log.info("requestId[{}] has generated", (Object)slot.getRequestId());
        }
        if (!isChildFlow) {
            slot.setRequestData(param);
            slot.setFlowId(flowId);
        }
        try {
            flow.execute(slotIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            slot.setSuccess(false);
            slot.setErrorMsg(e.getMessage());
        }
        finally {
            if (!isChildFlow) {
                slot.printStep();
                SlotBus.releaseSlot(slotIndex);
            }
        }
        return (T)slot;
    }

    public void process(String processSetId, ResponseMessage message) throws Exception {
        System.out.println("\u52a8\u6001\u4e8b\u4ef6\u5904\u7406==============");
        System.out.println("\u52a8\u6001\u4e8b\u4ef6\u5904\u7406==============");
        System.out.println("\u52a8\u6001\u4e8b\u4ef6\u5904\u7406==============");
        this.execute(processSetId, message);
    }
}

