/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.event.flow.core;

import com.xforceplus.janus.message.event.flow.core.data.Slot;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotBus {
    private static final Logger log = LoggerFactory.getLogger(SlotBus.class);
    public static final int SLOT_SIZE = 1024;
    public static AtomicInteger OCCUPY_COUNT = new AtomicInteger(0);
    private static Slot[] slots = new Slot[1024];

    public static synchronized int offerSlot(Class<? extends Slot> slotClazz) {
        try {
            for (int i = 0; i < slots.length; ++i) {
                if (slots[i] != null) continue;
                SlotBus.slots[i] = slotClazz.newInstance();
                OCCUPY_COUNT.incrementAndGet();
                return i;
            }
        }
        catch (Exception e) {
            log.error("offer slot error", (Throwable)e);
            return -1;
        }
        return -1;
    }

    public static <T extends Slot> T getSlot(int slotIndex) {
        return (T)slots[slotIndex];
    }

    public static void releaseSlot(int slotIndex) {
        if (slots[slotIndex] != null) {
            log.info("[{}]:slot[{}] released", (Object)slots[slotIndex].getRequestId(), (Object)slotIndex);
            SlotBus.slots[slotIndex] = null;
            OCCUPY_COUNT.decrementAndGet();
        } else {
            log.warn("slot[{}] already has been released", (Object)slotIndex);
        }
    }
}

