/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.event.flow.core.data;

import com.xforceplus.janus.message.event.flow.core.data.Slot;
import com.xforceplus.janus.message.event.flow.core.flow.CmpStep;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsSlot
implements Slot {
    private static final Logger log = LoggerFactory.getLogger(AbsSlot.class);
    public static final String REQUEST = "request";
    private final String RESPONSE = "response";
    private final String COND_NODE_PREFIX = "cond_";
    private final String NODE_INPUT_PREFIX = "input_";
    private final String NODE_OUTPUT_PREFIX = "output_";
    private final String REQUEST_ID = "req_id";
    private final String FLOW_ID = "flow_id";
    private boolean isSuccess = true;
    private boolean isStart = false;
    private boolean isEnd = false;
    private String errorMsg;
    private String currNodeId;
    private String nextNodeId;
    private Deque<CmpStep> executeSteps = new ArrayDeque<CmpStep>();
    protected ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap();

    @Override
    public <T> T getInput(String nodeId) {
        return (T)this.dataMap.get("input_" + nodeId);
    }

    @Override
    public <T> T getOutput(String nodeId) {
        return (T)this.dataMap.get("output_" + nodeId);
    }

    @Override
    public <T> void setInput(String nodeId, T t) {
        this.dataMap.put("input_" + nodeId, t);
    }

    @Override
    public <T> void setOutput(String nodeId, T t) {
        this.dataMap.put("output_" + nodeId, t);
    }

    @Override
    public <T> T getRequestData() {
        return (T)this.dataMap.get(REQUEST);
    }

    @Override
    public <T> void setRequestData(T t) {
        this.dataMap.put(REQUEST, t);
    }

    @Override
    public <T> T getResponseData() {
        return (T)this.dataMap.get("response");
    }

    @Override
    public <T> void setResponseData(T t) {
        this.dataMap.put("response", t);
    }

    @Override
    public <T> T getData(String key) {
        return (T)this.dataMap.get(key);
    }

    @Override
    public <T> void setData(String key, T t) {
        this.dataMap.put(key, t);
    }

    @Override
    public void addStep(CmpStep step) {
        this.executeSteps.add(step);
    }

    @Override
    public void setFlowId(String flowId) {
        this.dataMap.put("flow_id", flowId);
    }

    @Override
    public String getFlowId() {
        return (String)this.dataMap.get("flow_id");
    }

    @Override
    public void printStep() {
        StringBuffer str = new StringBuffer();
        CmpStep cmpStep = null;
        Iterator<CmpStep> it = this.executeSteps.iterator();
        while (it.hasNext()) {
            cmpStep = it.next();
            str.append(cmpStep);
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        log.info("[{}]:FLOW_NAME[{}]\n{}", new Object[]{this.getRequestId(), this.getFlowId(), str.toString()});
    }

    @Override
    public void generateRequestId() {
        this.dataMap.put("req_id", new Long(System.nanoTime()).toString());
    }

    @Override
    public String getRequestId() {
        return (String)this.dataMap.get("req_id");
    }

    public Deque<CmpStep> getExecuteSteps() {
        return this.executeSteps;
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public String getCurrNodeId() {
        return this.currNodeId;
    }

    @Override
    public void setCurrNodeId(String currNodeId) {
        this.currNodeId = currNodeId;
    }

    @Override
    public void setEnd(boolean end) {
        this.isEnd = end;
    }

    @Override
    public boolean isEnd() {
        return this.isEnd;
    }
}

