/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.event.flow.core.flow;

import com.xforceplus.janus.message.event.flow.core.AbsNodeExecutor;
import com.xforceplus.janus.message.event.flow.core.SlotBus;
import com.xforceplus.janus.message.event.flow.core.exception.FlowSystemException;
import com.xforceplus.janus.message.event.flow.core.flow.Node;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flow<T> {
    private static final Logger log = LoggerFactory.getLogger(Flow.class);
    private String id;
    private String name;
    @Valid
    @NotNull(message="\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a")
    private @Valid @NotNull(message="\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a") List<Node<T>> nodeList;

    public Flow(String id, String name, @Valid @NotNull(message="\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a") @Valid @NotNull(message="\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a") List<Node<T>> nodeList) {
        this.id = id;
        this.name = name;
        this.nodeList = nodeList;
    }

    public void execute(Integer slotIndex) throws Exception {
        if (CollectionUtils.isEmpty(this.nodeList)) {
            throw new FlowSystemException("no nodeList in this flow [" + this.name + "] ,id [" + this.id + "]");
        }
        Object slot = SlotBus.getSlot(slotIndex);
        for (Node<T> node : this.nodeList) {
            if (slot.isEnd()) {
                log.warn("event process early interrupt requestId : {} ", (Object)slot.getRequestId());
                break;
            }
            AbsNodeExecutor executor = AbsNodeExecutor.nodeType2Executor.get(node.getNodeType());
            executor.setSlotIndex(slotIndex).execute(node);
        }
    }

    public Node getNodeModel(String nodeId) {
        if (null == this.nodeList || this.nodeList.isEmpty()) {
            return null;
        }
        for (Node<T> node : this.nodeList) {
            if (!node.getId().equals(nodeId)) continue;
            return node;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Node<T>> getNodeList() {
        return this.nodeList;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNodeList(List<Node<T>> nodeList) {
        this.nodeList = nodeList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Node<T>> this$nodeList = this.getNodeList();
        List<Node<T>> other$nodeList = other.getNodeList();
        return !(this$nodeList == null ? other$nodeList != null : !((Object)this$nodeList).equals(other$nodeList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Node<T>> $nodeList = this.getNodeList();
        result = result * 59 + ($nodeList == null ? 43 : ((Object)$nodeList).hashCode());
        return result;
    }

    public String toString() {
        return "Flow(id=" + this.getId() + ", name=" + this.getName() + ", nodeList=" + this.getNodeList() + ")";
    }
}

