package com.xforceplus.janus.message.sdk;

import java.io.Serializable;

/**
 * 响应消息
 *
 * @author zhujie@xforceplus.com
 * @date 2021/3/3 2:53 PM
 **/

/**
 * 响应消息
 */
public class ResponseMessage extends RequestMessage implements Serializable {

    //消息ID，总线服务生成
    private Long id;

    //发布代码
    private String pubCode;

    //发布者appKey
    private String pubAppKey;

    //第三方消息ID
    private String thirdPartyId;

    //接收时间戳，用来记录消息总线服务接收到消息的时间点
    private long receivedTime;

    //处理时间，单位：毫秒，用来记录总线服务过滤、打标签等操作后的处理时间
    private long processedTime;

    //消费次数，消息被订阅者或者消费者消费次数
    private Integer consumeTimes;

    //回执标记
    private String receiptHandle;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPubCode() {
        return pubCode;
    }

    public void setPubCode(String pubCode) {
        this.pubCode = pubCode;
    }

    public String getPubAppKey() {
        return pubAppKey;
    }

    public void setPubAppKey(String pubAppKey) {
        this.pubAppKey = pubAppKey;
    }

    public String getThirdPartyId() {
        return thirdPartyId;
    }

    public void setThirdPartyId(String thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
    }

    public long getReceivedTime() {
        return receivedTime;
    }

    public void setReceivedTime(long receivedTime) {
        this.receivedTime = receivedTime;
    }

    public long getProcessedTime() {
        return processedTime;
    }

    public void setProcessedTime(long processedTime) {
        this.processedTime = processedTime;
    }

    public Integer getConsumeTimes() {
        return consumeTimes;
    }

    public void setConsumeTimes(Integer consumeTimes) {
        this.consumeTimes = consumeTimes;
    }

    public String getReceiptHandle() {
        return receiptHandle;
    }

    public void setReceiptHandle(String receiptHandle) {
        this.receiptHandle = receiptHandle;
    }
}
