package com.xforceplus.janus.message.sdk.request;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.sdk.Constants;
import com.xforceplus.janus.message.sdk.core.AbsMbRequest;
import com.xforceplus.janus.message.sdk.response.AddSubRuleResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:43 AM
 **/
public class AddSubRuleRequest extends AbsMbRequest<AddSubRuleResponse> {
    private String pubAppKey;
    private String pubCode;
    private String propName;
    private String propType;
    private String propVal;

    public AddSubRuleRequest(String pubAppKey, String pubCode, String propName, String propType, String propVal) {
        this.pubAppKey = pubAppKey;
        this.pubCode = pubCode;
        this.propName = propName;
        this.propType = propType;
        this.propVal = propVal;
    }

    @Override
    public String httpMethod() {
        return Constants.HTTP_METHOD_POST;
    }

    @Override
    public String getParamJson() {
        Map<String, String> param = new HashMap<>();
        param.put("pubAppKey", this.getPubAppKey());
        param.put("pubCode", this.getPubCode());
        param.put("propName", this.getPropName());
        param.put("propType", this.getPropType());
        param.put("propVal", this.getPropVal());
        return JacksonUtil.getInstance().toJson(param);
    }

    @Override
    public Map<String, String> getParam() {
        return null;
    }

    @Override
    public String getRequestPath() {
        return Constants.MB_REQUEST_PATH_ADD_SUB_RULE;
    }

    @Override
    public Class<AddSubRuleResponse> getResponseClass() {
        return AddSubRuleResponse.class;
    }

    public String getPubAppKey() {
        return pubAppKey;
    }

    public void setPubAppKey(String pubAppKey) {
        this.pubAppKey = pubAppKey;
    }

    public String getPubCode() {
        return pubCode;
    }

    public void setPubCode(String pubCode) {
        this.pubCode = pubCode;
    }

    public String getPropName() {
        return propName;
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public String getPropType() {
        return propType;
    }

    public void setPropType(String propType) {
        this.propType = propType;
    }

    public String getPropVal() {
        return propVal;
    }

    public void setPropVal(String propVal) {
        this.propVal = propVal;
    }
}
