package com.xforceplus.janus.message.sdk.response;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.janus.message.sdk.core.AbsMbResponse;
import com.xforceplus.janus.message.sdk.core.HttpResp;
import com.xforceplus.janus.message.sdk.dto.Result;

import org.apache.http.HttpStatus;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:41 AM
 **/
public class AckResponse extends AbsMbResponse<AckResponse> {

    public static AckResponse transform(HttpResp httpResp) {
        AckResponse response = new AckResponse();
        response.setSuccess(true);
        if (httpResp.getHttpStatus() != HttpStatus.SC_OK) {
            response.setSuccess(false);
            response.setError(httpResp.getRespStr());
        }
        ObjectMapper mapper = new ObjectMapper();

        Result<String> result = null;
        try {
            result = mapper.readValue(httpResp.getRespStr(), new TypeReference<Result<String>>() {
            });
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        ;

        if (!Result.ResultCode.OK.getCode().equals(result.getCode())) {
            response.setSuccess(false);
            response.setError(result.getMessage());
        }

        return response;
    }
}
