package com.xforceplus.janus.message.sdk.dto;


public class Result<T> {

    private static final String MSG_PREFIX = "MSG";

    public enum ResultCode {
        // ---------------------------
        // 0000       处理成功
        // 1000～1999 区间表示参数错误
        // 2000～2999 区间表示用户错误
        // 3000～3999 区间表示系统业务异常
        // ---------------------------

        OK(MSG_PREFIX + "CZZ0000", "处理成功");

        private final String code;
        private final String message;

        ResultCode(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }

        public String getMessage() {
            return message;
        }
        }


    //状态码
    private String code;

    //消息
    private String message;

    //返回数据
    private T result;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }
}
