package com.xforceplus.janus.message.sdk.response;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.janus.message.sdk.ResponseMessage;
import com.xforceplus.janus.message.sdk.core.AbsMbResponse;
import com.xforceplus.janus.message.sdk.core.HttpResp;
import com.xforceplus.janus.message.sdk.dto.Result;

import org.apache.http.HttpStatus;

import java.util.List;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:41 AM
 **/
public class SubResponse extends AbsMbResponse<SubResponse> {

    private List<ResponseMessage> responseMessages;

    public List<ResponseMessage> getResponseMessages() {
        return responseMessages;
    }

    public void setResponseMessages(List<ResponseMessage> responseMessages) {
        this.responseMessages = responseMessages;
    }

    public static SubResponse transform(HttpResp httpResp) {
        SubResponse response = new SubResponse();
        response.setSuccess(true);
        if (httpResp.getHttpStatus() != HttpStatus.SC_OK) {
            response.setSuccess(false);
            response.setError(httpResp.getRespStr());
        }
        ObjectMapper mapper = new ObjectMapper();

        Result<List<ResponseMessage>> result = null;
        try {
            result = mapper.readValue(httpResp.getRespStr(), new TypeReference<Result<List<ResponseMessage>>>() {
            });
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        ;

        if (!Result.ResultCode.OK.getCode().equals(result.getCode())) {
            response.setSuccess(false);
            response.setError(result.getMessage());
        }
        response.setResponseMessages(result.getResult());

        return response;
    }
}
